//AIM:Computing overall signal attenuation,signal attenuation/km,overall 
//signal attenuation for 20km link with splices at 2km interval

//Software version Scilab 5.5.2
//OS Windows 7
clc;
clear;
//Let us consider that each splice gives attenuation of 1.5dB for 10km long 
//optical fiber having output optical power of 4 µW
//and  input optical power of 100µW

Pin=100*(10^(-6));//Pin=Input optical power
Pout=4*(10^(-6));//Pout=Output optical power
alphaT=10*log10(Pin/Pout);//alphaT=Overall attenuation
disp('dB',alphaT,'Overall attenuation (alphaT)=')
//The length of the optical fiber is 10km
L1=10*(10^(3));
//Computing Signal attenuaion per km
alpha=alphaT/10;
disp('dB/km',alpha,'The signal attenuation per kilometer (alpha) =')
//Computation for 20kms length:
L2=20*(10^(3));
TSA=alpha/(10^(3))*L2;//TSA=Total signal attenuation
disp('dB',TSA,'Total signal attenuation=')
//A splice is connected at each 2km distance.Thus total 9 splices are used.
//Now each splice gives 1.5dB attenuation.
S=9;//S=Total No. of splices used
A=1.5;//A=Attenuation by each splice
TAFS=S*A;//TAFS=Total attenuation from splices
disp('dB',TAFS,'Total attenuation from splices=')
//Computing overall signal attenuation including attenuation due to splices
a=TAFS+TSA;
disp('dB',a,'Overall signal attenuation including attenuation due to splices=')

